/*
 * Copyright (C) 2013 Google, Inc. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY GOOGLE INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL GOOGLE INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include "core/html/parser/HTMLParserOptions.h"

#include "bindings/core/v8/ScriptController.h"
#include "core/dom/Document.h"
#include "core/frame/LocalFrame.h"
#include "core/frame/Settings.h"
#include "core/loader/FrameLoader.h"

namespace blink {

HTMLParserOptions::HTMLParserOptions(Document* document)
{
    LocalFrame* frame = document ? document->frame() : 0;
    scriptEnabled = frame && frame->script().canExecuteScripts(NotAboutToExecuteScript);
    pluginsEnabled = frame && frame->loader().allowPlugins(NotAboutToInstantiatePlugin);

    // We force the main-thread parser for three cases:
    // - about:blank and javascript (which uses about:blank) for compatibility
    //   with historical synchronous loading/parsing behavior.
    // - HTML imports (FIXME: enable off-thread parser for this case)
    // - inspector/DOMPatchSupport replacing the whole document.
    //   (DOMPatchSupport calls in |DocumentParser::pinToMainThread()| for this case)
    // FIXME: Gecko does not load javascript: urls synchronously, why do we?
    // See LayoutTests/loader/iframe-sync-loads.html
    useThreading = document && !document->importsController() && !document->url().isAboutBlankURL();
}

}
